//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoRevolver extends DeusExAmmo;

#exec MESH IMPORT MESH=RevolverAmmo ANIVFILE=MODELS\RevolverAmmo_a.3d DATAFILE=MODELS\RevolverAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=RevolverAmmo X=0 Y=0 Z=100 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=RevolverAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RevolverAmmo SEQ=RevolverAmmo STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RevolverAmmo SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=RevolverAmmo MESH=RevolverAmmo
#exec MESHMAP SCALE MESHMAP=RevolverAmmo X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\CBAGray.pcx"	NAME="RevAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBAGold.pcx"	NAME="RevAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBADGold.pcx"	NAME="RevADGold"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=RevolverAmmo NUM=0 TEXTURE=RevAGray
#exec MESHMAP SETTEXTURE MESHMAP=RevolverAmmo NUM=1 TEXTURE=RevAGold
#exec MESHMAP SETTEXTURE MESHMAP=RevolverAmmo NUM=2 TEXTURE=RevADGold

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=6
     MaxAmmo=384
     ItemName="Revolver Rounds"
     ItemArticle="some"
     PickupViewMesh=LodMesh'RevolverAmmo'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmo3006'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'RevolverAmmo'
     CollisionRadius=2.500000
     CollisionHeight=1.750000
     Drawscale=0.500000
     PickupViewScale=0.500000
     bCollideActors=True
}
